/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.serialize;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mrcrayfish.framework.api.serialize.DataEntry;
import com.mrcrayfish.framework.api.serialize.DataType;
import java.util.function.Consumer;

public final class DataArray
extends DataEntry {
    private final ImmutableList<DataEntry> values;

    DataArray(JsonArray array) {
        super(DataType.ARRAY);
        this.values = DataArray.construct(array);
    }

    public int length() {
        return this.values.size();
    }

    public void forEach(Consumer<DataEntry> consumer) {
        this.values.forEach(consumer);
    }

    public DataEntry get(int index) {
        return (DataEntry)this.values.get(index);
    }

    public ImmutableList<DataEntry> values() {
        return this.values;
    }

    @Override
    protected JsonElement toJson() {
        JsonArray array = new JsonArray();
        this.values.forEach(entry -> array.add(entry.toJson()));
        return array;
    }

    private static ImmutableList<DataEntry> construct(JsonArray array) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        array.forEach(element -> {
            DataEntry entry = DataArray.convertElement(element);
            if (entry != null) {
                builder.add((Object)entry);
            }
        });
        return builder.build();
    }
}

