/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.neoforge.mixin;

import com.sk89q.worldedit.neoforge.internal.ExtendedChunk;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainerFactory;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(value={LevelChunk.class})
public abstract class MixinLevelChunkSetBlockHook
extends ChunkAccess
implements ExtendedChunk {
    private boolean shouldUpdate = true;

    public MixinLevelChunkSetBlockHook(ChunkPos chunkPos, UpgradeData upgradeData, LevelHeightAccessor levelHeightAccessor, PalettedContainerFactory palettedContainerFactory, long l, @Nullable LevelChunkSection[] levelChunkSections, @Nullable BlendingData blendingData) {
        super(chunkPos, upgradeData, levelHeightAccessor, palettedContainerFactory, l, levelChunkSections, blendingData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @javax.annotation.Nullable
    public BlockState setBlockState(BlockPos pos, BlockState state, int flag, boolean update) {
        this.shouldUpdate = update;
        try {
            BlockState blockState = this.setBlockState(pos, state, flag);
            return blockState;
        }
        finally {
            this.shouldUpdate = true;
        }
    }

    @Redirect(method={"setBlockState"}, slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;is(Lnet/minecraft/world/level/block/Block;)Z")), at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;onPlace(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V"))
    public void setBlockStateHook(BlockState target, Level world, BlockPos pos, BlockState old, boolean move) {
        MinecraftServer server = world.getServer();
        boolean localShouldUpdate = server == null || Thread.currentThread() != server.getRunningThread() ? true : this.shouldUpdate;
        if (localShouldUpdate) {
            target.onPlace(world, pos, old, move);
        }
    }
}

