/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished;

import com.mrcrayfish.framework.api.event.FrameworkPlayerEvents;
import com.mrcrayfish.framework.api.event.FrameworkTickEvents;
import com.mrcrayfish.furniture.refurbished.block.DoorMatBlock;
import com.mrcrayfish.furniture.refurbished.block.FryingPanBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.CuttingBoardBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.FryingPanBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.GrillBlockEntity;
import com.mrcrayfish.furniture.refurbished.computer.Computer;
import com.mrcrayfish.furniture.refurbished.computer.IService;
import com.mrcrayfish.furniture.refurbished.computer.app.CoinMiner;
import com.mrcrayfish.furniture.refurbished.computer.app.HomeControl;
import com.mrcrayfish.furniture.refurbished.computer.app.Marketplace;
import com.mrcrayfish.furniture.refurbished.computer.app.PaddleBall;
import com.mrcrayfish.furniture.refurbished.core.ModBlocks;
import com.mrcrayfish.furniture.refurbished.core.ModDataComponents;
import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.electricity.LinkManager;
import com.mrcrayfish.furniture.refurbished.image.PaletteImage;
import com.mrcrayfish.furniture.refurbished.item.PackageItem;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageToolAnimation;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.class_1264;
import net.minecraft.class_1269;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_9331;
import net.minecraft.server.MinecraftServer;

public class Bootstrap {
    public static void init() {
        Bootstrap.registerDispenserBehaviours();
        Bootstrap.registerCauldronBehaviours();
        Bootstrap.registerFrameworkEvents();
        Computer computer = Computer.get();
        computer.installProgram(Utils.resource("paddle_ball"), PaddleBall::new);
        computer.installProgram(Utils.resource("home_control"), HomeControl::new);
        computer.installProgram(Utils.resource("marketplace"), Marketplace::new);
        computer.installProgram(Utils.resource("coin_miner"), CoinMiner::new);
        computer.installService(PaddleBall.SERVICE);
    }

    private static void registerFrameworkEvents() {
        FrameworkTickEvents.START_SERVER.register(server -> {
            DeliveryService.get(server).ifPresent(DeliveryService::serverTick);
            Computer.get().getServices().forEach(IService::tick);
        });
        FrameworkTickEvents.END_PLAYER.register(player -> {
            MinecraftServer server = player.method_73183().method_8503();
            if (server != null) {
                LinkManager.get(server).ifPresent(manager -> manager.onPlayerTick(player));
            }
        });
        FrameworkPlayerEvents.LOGGED_OUT.register(player -> {
            MinecraftServer server = player.method_73183().method_8503();
            if (server != null) {
                LinkManager.get(server).ifPresent(manager -> manager.onPlayerLoggedOut(player));
            }
        });
    }

    private static void registerDispenserBehaviours() {
        class_2315.method_10009(() -> ModItems.SPATULA.get(), (source, stack) -> {
            FryingPanBlockEntity fryingPan;
            GrillBlockEntity grill;
            class_2350 direction = (class_2350)source.comp_1969().method_11654((class_2769)class_2315.field_10918);
            class_2338 pos = source.comp_1968().method_10093(direction).method_10074();
            class_2586 patt0$temp = source.comp_1967().method_8321(pos);
            if (patt0$temp instanceof GrillBlockEntity && (grill = (GrillBlockEntity)patt0$temp).flipItems()) {
                FryingPanBlock.playSpatulaScoopSound((class_1937)source.comp_1967(), pos.method_10084(), 0.0);
                Network.getPlay().sendToTrackingBlockEntity(() -> grill, (Object)new MessageToolAnimation(MessageToolAnimation.Tool.SPATULA, source.comp_1968(), direction));
                return stack;
            }
            pos = source.comp_1968().method_10093(direction);
            class_2586 patt1$temp = source.comp_1967().method_8321(pos);
            if (patt1$temp instanceof FryingPanBlockEntity && (fryingPan = (FryingPanBlockEntity)patt1$temp).isFlippingNeeded()) {
                fryingPan.flipItem();
                FryingPanBlock.playSpatulaScoopSound((class_1937)source.comp_1967(), pos, 0.1875);
                Network.getPlay().sendToTrackingBlockEntity(() -> fryingPan, (Object)new MessageToolAnimation(MessageToolAnimation.Tool.SPATULA, source.comp_1968(), direction));
                return stack;
            }
            return stack;
        });
        class_2315.method_10009(() -> ModItems.KNIFE.get(), (source, stack) -> {
            CuttingBoardBlockEntity cuttingBoard;
            class_2350 direction = (class_2350)source.comp_1969().method_11654((class_2769)class_2315.field_10918);
            class_2338 pos = source.comp_1968().method_10093(direction);
            class_2586 patt0$temp = source.comp_1967().method_8321(pos);
            if (patt0$temp instanceof CuttingBoardBlockEntity && (cuttingBoard = (CuttingBoardBlockEntity)patt0$temp).sliceItem((class_1937)source.comp_1967(), false)) {
                stack.method_7956(1, source.comp_1967(), null, item -> stack.method_7939(0));
                Network.getPlay().sendToTrackingBlockEntity(() -> cuttingBoard, (Object)new MessageToolAnimation(MessageToolAnimation.Tool.KNIFE, source.comp_1968(), direction));
            }
            return stack;
        });
        class_2315.method_10009(() -> ModItems.PACKAGE.get(), (source, stack) -> {
            class_2350 direction = (class_2350)source.comp_1969().method_11654((class_2769)class_2315.field_10918);
            class_243 pos = source.comp_1968().method_10093(direction).method_46558();
            PackageItem.getPackagedItems(stack).method_57489().forEach(s -> class_1264.method_5449((class_1937)source.comp_1967(), (double)pos.field_1352, (double)pos.field_1351, (double)pos.field_1350, (class_1799)s));
            return class_1799.field_8037;
        });
    }

    private static void registerCauldronBehaviours() {
        class_5620.field_27776.comp_1982().put(((DoorMatBlock)ModBlocks.DOOR_MAT.get()).method_8389(), (state, level, pos, player, hand, stack) -> {
            PaletteImage image;
            class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
            if (block == ModBlocks.DOOR_MAT.get() && (image = (PaletteImage)stack.method_58694((class_9331)ModDataComponents.PALETTE_IMAGE.get())) != null) {
                if (!level.method_8608()) {
                    class_1799 copy = stack.method_46651(1);
                    copy.method_57381((class_9331)ModDataComponents.PALETTE_IMAGE.get());
                    stack.method_7934(1);
                    if (stack.method_7960()) {
                        player.method_6122(hand, copy);
                    } else if (player.method_7270(copy)) {
                        player.field_7498.method_34252();
                    } else {
                        player.method_7328(copy, false);
                    }
                    class_5556.method_31650((class_2680)state, (class_1937)level, (class_2338)pos);
                }
                return class_1269.field_5812;
            }
            return class_1269.field_52423;
        });
    }
}

