/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mojang.serialization.Codec;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.Constants;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.blockentity.IProcessingBlock;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.RecycleBinMenu;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_7225;
import net.minecraft.class_8942;

public class RecycleBinBlockEntity
extends ElectricityModuleLootBlockEntity
implements IProcessingBlock,
IPowerSwitch,
ILevelAudio,
IHomeControlDevice,
class_1275 {
    public static final int[] INPUT_SLOTS = new int[]{0, 1, 2};
    public static final int DATA_POWERED = 0;
    public static final int DATA_ENABLED = 1;
    public static final int DATA_PROCESSING_TIME = 2;
    public static final int DATA_RECYCLED = 3;
    protected final class_243 audioPosition;
    protected boolean powered;
    protected boolean processing;
    protected int processingTime;
    protected boolean enabled;
    protected int recycled;
    protected final class_3913 data = new BuildableContainerData(builder -> {
        builder.add(1, () -> this.enabled ? 1 : 0, value -> {});
        builder.add(0, () -> this.powered ? 1 : 0, value -> {});
        builder.add(2, () -> this.processingTime, value -> {});
        builder.add(3, () -> this.recycled, value -> {});
    });

    public RecycleBinBlockEntity(class_2338 pos, class_2680 state) {
        this((class_2591)ModBlockEntities.RECYCLE_BIN.get(), pos, state);
    }

    public RecycleBinBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, 3);
        this.audioPosition = pos.method_46558();
    }

    @Override
    public int[] method_5494(class_2350 direction) {
        return INPUT_SLOTS;
    }

    @Override
    public boolean isMatchingContainerMenu(class_1703 menu) {
        RecycleBinMenu recycleBin;
        return menu instanceof RecycleBinMenu && (recycleBin = (RecycleBinMenu)menu).getContainer() == this;
    }

    protected class_2561 method_17823() {
        return Utils.translation("container", "recycle_bin", new Object[0]);
    }

    protected class_1703 method_5465(int windowId, class_1661 playerInventory) {
        return new RecycleBinMenu(windowId, playerInventory, (class_1263)this, this.data);
    }

    @Override
    public class_3414 getSound() {
        return (class_3414)ModSounds.BLOCK_RECYCLE_BIN_ENGINE.get();
    }

    @Override
    public class_3419 getSource() {
        return class_3419.field_15245;
    }

    @Override
    public class_243 getAudioPosition() {
        return this.audioPosition;
    }

    @Override
    public boolean canPlayAudio() {
        return this.isNodePowered() && this.processing && this.enabled && !this.method_11015();
    }

    @Override
    public int getAudioHash() {
        return this.field_11867.hashCode();
    }

    @Override
    public boolean isAudioEqual(ILevelAudio other) {
        return other == this;
    }

    @Override
    public boolean isNodePowered() {
        return this.powered;
    }

    @Override
    public void setNodePowered(boolean powered) {
        this.powered = powered;
        this.method_5431();
        this.sync();
    }

    @Override
    public int getEnergy() {
        return 0;
    }

    @Override
    public void addEnergy(int energy) {
    }

    @Override
    public boolean requiresEnergy() {
        return false;
    }

    @Override
    public int retrieveEnergy(boolean simulate) {
        return 0;
    }

    @Override
    public int updateAndGetTotalProcessingTime() {
        return this.getTotalProcessingTime();
    }

    @Override
    public int getTotalProcessingTime() {
        return (Integer)Config.SERVER.recycleBin.processingTime.get();
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setProcessingTime(int time) {
        this.processingTime = time;
    }

    @Override
    public void onCompleteProcess() {
        this.recycleItem();
    }

    @Override
    public boolean canProcess() {
        if (this.enabled && this.isNodePowered()) {
            for (int index : INPUT_SLOTS) {
                if (this.method_5438(index).method_7960()) continue;
                return !this.isMaxExperience();
            }
        }
        return false;
    }

    private int getCurrentExperiencePoints() {
        return (int)class_3532.method_15350((double)((double)this.recycled * (Double)Config.SERVER.recycleBin.experiencePerItem.get()), (double)0.0, (double)this.getMaxExperience());
    }

    private boolean isMaxExperience() {
        return this.getCurrentExperiencePoints() >= this.getMaxExperience();
    }

    public void withdrawExperience(class_3222 player) {
        int points = this.getCurrentExperiencePoints();
        if (points > 0) {
            player.method_51469().method_8649((class_1297)new class_1303((class_1937)player.method_51469(), player.method_23317(), player.method_23318(), player.method_23321(), points));
            this.recycled = 0;
            this.method_5431();
        }
    }

    private int getMaxExperience() {
        int maxLevel = (Integer)Config.SERVER.recycleBin.maximumExperienceLevels.get();
        if (maxLevel <= 16) {
            return class_3532.method_34954((int)maxLevel) + 6 * maxLevel;
        }
        if (maxLevel <= 31) {
            return (int)(2.5 * (double)class_3532.method_34954((int)maxLevel) - 40.5 * (double)maxLevel + 360.0);
        }
        return (int)(4.5 * (double)class_3532.method_34954((int)maxLevel) - 162.5 * (double)maxLevel + 2220.0);
    }

    @Override
    public void togglePower() {
        this.enabled = !this.enabled;
        this.method_5431();
        this.sync();
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, RecycleBinBlockEntity recycleBin) {
        boolean processing = recycleBin.processTick();
        if (recycleBin.processing != processing) {
            recycleBin.processing = processing;
            recycleBin.sync();
        }
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, RecycleBinBlockEntity recycleBin) {
        AudioManager.get().playLevelAudio(recycleBin);
    }

    @Override
    public void method_11014(class_11368 input) {
        super.method_11014(input);
        input.method_71426("Powered", (Codec)Codec.BOOL).ifPresent(value -> {
            this.powered = value;
        });
        input.method_71426("Enabled", (Codec)Codec.BOOL).ifPresent(value -> {
            this.enabled = value;
        });
        input.method_71439("ProcessTime").ifPresent(value -> {
            this.processingTime = value;
        });
        input.method_71426("Processing", (Codec)Codec.BOOL).ifPresent(value -> {
            this.processing = value;
        });
        input.method_71439("Recycled").ifPresent(value -> {
            this.recycled = Math.max(value, 0);
        });
    }

    @Override
    protected void method_11007(class_11372 output) {
        super.method_11007(output);
        output.method_71468("Powered", (Codec)Codec.BOOL, (Object)this.powered);
        output.method_71468("Enabled", (Codec)Codec.BOOL, (Object)this.enabled);
        output.method_71465("ProcessTime", this.processingTime);
        output.method_71465("Recycled", this.recycled);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 provider) {
        try (class_8942.class_11340 collector = new class_8942.class_11340(this.method_71402(), Constants.LOG);){
            class_11362 output = class_11362.method_71459((class_8942)collector, (class_7225.class_7874)provider);
            this.writeNodeNbt((class_11372)output);
            output.method_71468("Powered", (Codec)Codec.BOOL, (Object)this.powered);
            output.method_71468("Enabled", (Codec)Codec.BOOL, (Object)this.enabled);
            output.method_71468("Processing", (Codec)Codec.BOOL, (Object)this.processing);
            BlockEntityHelper.saveCustomName((class_11372)output, this.method_5797());
            class_2487 class_24872 = output.method_71475();
            return class_24872;
        }
    }

    private void sync() {
        if (!this.field_11863.method_8608()) {
            BlockEntityHelper.sendCustomUpdate((class_2586)this, class_2586::method_16887);
        }
    }

    private void recycleItem() {
        for (int index : INPUT_SLOTS) {
            class_1799 stack = this.method_5438(index);
            if (stack.method_7960()) continue;
            stack.method_7934(1);
            ++this.recycled;
            this.method_5431();
            break;
        }
    }

    @Override
    public class_2338 getDevicePos() {
        return this.field_11867;
    }

    @Override
    public boolean isDeviceEnabled() {
        return this.enabled;
    }

    @Override
    public void toggleDeviceState() {
        this.enabled = !this.enabled;
        this.method_5431();
        BlockEntityHelper.sendCustomUpdate((class_2586)this, class_2586::method_16887);
    }

    @Override
    public void setDeviceState(boolean enabled) {
        this.enabled = enabled;
        this.method_5431();
        BlockEntityHelper.sendCustomUpdate((class_2586)this, class_2586::method_16887);
    }

    @Override
    public class_2561 getDeviceName() {
        if (this.method_16914()) {
            return this.method_5797();
        }
        return this.method_17823();
    }
}

