/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client;

import com.mrcrayfish.furniture.refurbished.core.ModItems;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11661;
import net.minecraft.class_11684;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.joml.Quaternionfc;

public class ToolAnimationRenderer {
    private static ToolAnimationRenderer instance;
    private final Map<class_2338, Animation> animationMap = new HashMap<class_2338, Animation>();

    public static ToolAnimationRenderer get() {
        if (instance == null) {
            instance = new ToolAnimationRenderer();
        }
        return instance;
    }

    private ToolAnimationRenderer() {
    }

    public void tick() {
        this.animationMap.entrySet().removeIf(entry -> {
            ((Animation)entry.getValue()).tick();
            return ((Animation)entry.getValue()).isFinished();
        });
    }

    public void submit(class_1937 level, class_243 camera, float partialTick) {
        class_4587 poseStack = new class_4587();
        poseStack.method_22904(-camera.field_1352, -camera.field_1351, -camera.field_1350);
        class_11684 renderDispatcher = class_310.method_1551().field_1773.method_72911();
        class_11661 storage = renderDispatcher.method_73003();
        this.animationMap.forEach((pos, animation) -> {
            int light = class_761.method_23794((class_1920)level, (class_2338)animation.pos);
            animation.submit(poseStack, (class_11659)storage, light, partialTick);
        });
    }

    public void playSpatulaAnimation(class_2338 dispenserPos, class_2350 direction) {
        this.animationMap.put(dispenserPos, new Animation(Tool.SPATULA, dispenserPos.method_10093(direction), direction));
    }

    public void playKnifeAnimation(class_2338 dispenserPos, class_2350 direction) {
        this.animationMap.put(dispenserPos, new Animation(Tool.KNIFE, dispenserPos.method_10093(direction), direction));
    }

    private static class Animation {
        private final class_10444 state;
        private final Tool tool;
        private final class_2338 pos;
        private final class_2350 direction;
        private int time;

        public Animation(Tool tool, class_2338 pos, class_2350 direction) {
            class_310 mc = class_310.method_1551();
            class_10444 state = new class_10444();
            mc.method_65386().method_65598(state, tool.stack.get(), class_811.field_4315, (class_1937)mc.field_1687, null, 0);
            this.state = state;
            this.tool = tool;
            this.pos = pos;
            this.direction = direction;
        }

        private boolean isFinished() {
            return this.time >= this.tool.animationTime;
        }

        private void tick() {
            if (this.time < this.tool.animationTime) {
                ++this.time;
            }
        }

        public void submit(class_4587 poseStack, class_11659 collector, int light, float partialTick) {
            poseStack.method_22903();
            poseStack.method_22904((double)this.pos.method_10263() + 0.5, (double)this.pos.method_10264(), (double)this.pos.method_10260() + 0.5);
            poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation(-1.5707964f * (float)this.direction.method_10161()));
            this.tool.transform.accept(poseStack, Float.valueOf((float)this.time + partialTick));
            this.state.method_65604(poseStack, collector, light, class_4608.field_21444, 0);
            poseStack.method_22909();
        }
    }

    private static enum Tool {
        SPATULA(() -> new class_1799((class_1935)ModItems.SPATULA.get()), 6, (poseStack, time) -> {
            poseStack.method_22904(0.0, 0.375, 0.0);
            poseStack.method_22904(-0.5, 0.0, -0.5);
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotation(0.7853982f));
            if (time.floatValue() >= 2.0f) {
                poseStack.method_22907((Quaternionfc)class_7833.field_40713.rotation(0.7853982f * ((time.floatValue() - 2.0f) / 2.0f)));
            }
            poseStack.method_22904(0.5, 0.0, 0.5);
            poseStack.method_22904(0.0, 0.0, -0.5 + (double)class_3532.method_15374((float)(time.floatValue() / 6.0f)) * 0.375);
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotation(1.5707964f));
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotation(0.7853982f));
            poseStack.method_22905(0.75f, 0.75f, 0.75f);
        }),
        KNIFE(() -> new class_1799((class_1935)ModItems.KNIFE.get()), 4, (poseStack, time) -> {
            poseStack.method_22904(0.0, 0.375, 0.0);
            poseStack.method_22904(-0.5, 0.0, -0.5);
            if (time.floatValue() >= 2.0f) {
                poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotation(0.7853982f * ((time.floatValue() - 2.0f) / 2.0f)));
            }
            poseStack.method_22904(0.5, 0.0, 0.5);
            poseStack.method_22904(0.0, 0.0, -0.5 + (double)(time.floatValue() / 4.0f) * 0.375);
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotation(1.5707964f));
            poseStack.method_22907((Quaternionfc)class_7833.field_40715.rotation(1.5707964f));
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotation(0.7853982f));
            poseStack.method_22905(0.75f, 0.75f, 0.75f);
        });

        private final Supplier<class_1799> stack;
        private final int animationTime;
        private final BiConsumer<class_4587, Float> transform;

        private Tool(Supplier<class_1799> stack, int animationTime, BiConsumer<class_4587, Float> transform) {
            this.stack = stack;
            this.animationTime = animationTime;
            this.transform = transform;
        }
    }
}

