/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.electricity;

import com.google.common.collect.Sets;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.electricity.WrenchContext;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.electricity.ISourceNode;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class PowerableArea {
    private final Set<class_2338> sourcePositions = new HashSet<class_2338>();
    private final Set<class_2338> lastSourcePositions = new HashSet<class_2338>();
    private class_265 cachedPowerableAreaShape;

    PowerableArea() {
    }

    public boolean exists() {
        return !this.sourcePositions.isEmpty();
    }

    public boolean containsLine(class_1937 level, class_243 start, class_243 end) {
        for (class_2338 pos : this.sourcePositions) {
            class_238 box = ISourceNode.createPowerableZone(level, pos);
            if (!box.method_1006(start) || !box.method_1006(end)) continue;
            return true;
        }
        return false;
    }

    public void updatePowerSources(class_1937 level, WrenchContext context) {
        this.sourcePositions.clear();
        if (context.selectedNode() != null) {
            this.scanNetworkForPowerSources(context.selectedNode(), this.sourcePositions);
            if (context.targetingNode() != null && this.sourcePositions.isEmpty()) {
                this.scanNetworkForPowerSources(context.targetingNode(), this.sourcePositions);
            }
            return;
        }
        Connection connection = context.hoveredConnection();
        if (connection != null && !connection.isCrossingPowerableZone(level)) {
            this.scanNetworkForPowerSources(level, connection, this.sourcePositions);
        }
    }

    private void scanNetworkForPowerSources(class_1937 level, Connection connection, Set<class_2338> found) {
        Sets.SetView delta;
        IElectricityNode a = connection.getNodeA(level);
        IElectricityNode b = connection.getNodeB(level);
        if (a != null && b != null && !(delta = Sets.symmetricDifference(a.getPowerSources(), b.getPowerSources())).isEmpty()) {
            found.add((class_2338)List.copyOf(delta).getFirst());
        }
    }

    private void scanNetworkForPowerSources(IElectricityNode start, Set<class_2338> found) {
        if (!start.isSourceNode()) {
            int searchLimit = (Integer)Config.SERVER.electricity.maximumNodesInNetwork.get();
            IElectricityNode.searchNodes(start, searchLimit, true, node -> !node.isSourceNode(), IElectricityNode::isSourceNode).forEach(node -> found.add(node.getNodePosition()));
            return;
        }
        found.add(start.getNodePosition());
    }

    @Nullable
    public class_265 getPowerableAreaShape() {
        class_310 mc = class_310.method_1551();
        if (this.sourcePositions.isEmpty() || mc.field_1687 == null) {
            return null;
        }
        if (this.lastSourcePositions.equals(this.sourcePositions)) {
            return this.cachedPowerableAreaShape;
        }
        this.sourcePositions.stream().map(pos -> ISourceNode.createPowerableZone((class_1937)mc.field_1687, pos)).map(aabb -> {
            class_265 shape1 = class_259.method_1078((class_238)aabb);
            class_265 shape2 = class_259.method_1078((class_238)aabb.method_1014(0.001));
            return Pair.of((Object)shape1, (Object)shape2);
        }).reduce((p1, p2) -> {
            class_265 shape1 = class_259.method_1082((class_265)((class_265)p1.first()), (class_265)((class_265)p2.first()), (class_247)class_247.field_1366);
            class_265 shape2 = class_259.method_1082((class_265)((class_265)p1.second()), (class_265)((class_265)p2.second()), (class_247)class_247.field_1366);
            return Pair.of((Object)shape1, (Object)shape2);
        }).map(pair -> class_259.method_1082((class_265)((class_265)pair.first()), (class_265)((class_265)pair.second()), (class_247)class_247.field_16893)).ifPresent(shape -> {
            this.cachedPowerableAreaShape = shape;
        });
        this.lastSourcePositions.clear();
        this.lastSourcePositions.addAll(this.sourcePositions);
        return this.cachedPowerableAreaShape;
    }

    public void invalidate() {
        this.sourcePositions.clear();
        this.lastSourcePositions.clear();
        this.cachedPowerableAreaShape = null;
    }
}

