/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mrcrayfish.furniture.refurbished.blockentity.FlipAnimation;
import com.mrcrayfish.furniture.refurbished.blockentity.GrillBlockEntity;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.state.CookingItemStackRenderState;
import com.mrcrayfish.furniture.refurbished.client.renderer.blockentity.state.GrillRenderState;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class GrillBlockEntityRenderer
implements class_827<GrillBlockEntity, GrillRenderState> {
    private final class_10442 itemModelResolver;

    public GrillBlockEntityRenderer(class_5614.class_5615 context) {
        this.itemModelResolver = context.comp_4536();
    }

    public GrillRenderState createRenderState() {
        return new GrillRenderState();
    }

    public void extractRenderState(GrillBlockEntity entity, GrillRenderState renderState, float partialTick, class_243 camera, @Nullable class_11683.class_11792 overlay) {
        class_10444 itemState;
        super.method_74331((class_2586)entity, (class_11954)renderState, partialTick, camera, overlay);
        class_2371<class_1799> foods = entity.getCookingItems();
        renderState.foods = new CookingItemStackRenderState[foods.size()];
        for (int i = 0; i < foods.size(); ++i) {
            CookingItemStackRenderState cookingItemState;
            class_1799 stack = (class_1799)foods.get(i);
            if (stack.method_7960()) continue;
            renderState.foods[i] = cookingItemState = new CookingItemStackRenderState();
            itemState = new class_10444();
            this.itemModelResolver.method_65598(itemState, stack, class_811.field_4315, entity.method_10997(), null, 0);
            cookingItemState.item = itemState;
            GrillBlockEntity.CookingSpace space = entity.getCookingSpace(i);
            cookingItemState.itemFlipped = space.isFlipped();
            cookingItemState.itemRotation = space.getRotation();
            FlipAnimation animation = space.getAnimation();
            cookingItemState.animationTime = animation.isPlaying() ? animation.getTime(partialTick) : 0.0f;
            cookingItemState.animationPlaying = animation.isPlaying();
        }
        class_2371<class_1799> fuels = entity.getFuelItems();
        renderState.fuels = new class_10444[fuels.size()];
        for (int i = 0; i < fuels.size(); ++i) {
            class_1799 stack = (class_1799)fuels.get(i);
            if (stack.method_7960()) continue;
            itemState = new class_10444();
            this.itemModelResolver.method_65598(itemState, stack, class_811.field_4315, entity.method_10997(), null, 0);
            renderState.fuels[i] = itemState;
        }
    }

    public void submit(GrillRenderState renderState, class_4587 stack, class_11659 collector, class_12075 cameraState) {
        int i;
        if (renderState.foods != null) {
            for (i = 0; i < renderState.foods.length; ++i) {
                CookingItemStackRenderState cookingItemState = renderState.foods[i];
                if (cookingItemState == null) continue;
                this.drawCookingSpace(cookingItemState, stack, i, renderState.field_62676, collector);
            }
        }
        if (renderState.fuels != null) {
            for (i = 0; i < renderState.fuels.length; ++i) {
                class_10444 itemState = renderState.fuels[i];
                if (itemState == null) continue;
                this.drawFuel(itemState, stack, i, renderState.field_62676, collector);
            }
        }
    }

    private void drawCookingSpace(CookingItemStackRenderState itemState, class_4587 stack, int quadrant, int light, class_11659 collector) {
        if (itemState.item != null) {
            float time = itemState.animationPlaying ? itemState.animationTime : 0.0f;
            float flipProgress = this.calculateFlipProgress(time);
            float flipHeight = 0.75f;
            stack.method_22903();
            stack.method_46416(0.0f, flipProgress * flipHeight, 0.0f);
            stack.method_22904(0.3 + 0.4 * (double)(quadrant % 2), 1.0, 0.3 + 0.4 * (double)(quadrant / 2));
            stack.method_22907((Quaternionfc)class_7833.field_40714.rotation(1.5707964f));
            stack.method_22907((Quaternionfc)class_7833.field_40718.rotation(1.5707964f * (float)itemState.itemRotation));
            stack.method_22907((Quaternionfc)class_7833.field_40714.rotation((float)Math.PI * -3 * time));
            stack.method_22907((Quaternionfc)class_7833.field_40714.rotation(!itemState.animationPlaying && itemState.itemFlipped ? (float)Math.PI : 0.0f));
            stack.method_22905(0.375f, 0.375f, 0.375f);
            itemState.item.method_65604(stack, collector, light, class_4608.field_21444, 0);
            stack.method_22909();
        }
    }

    private void drawFuel(class_10444 itemState, class_4587 stack, int index, int light, class_11659 collector) {
        stack.method_22903();
        stack.method_22904(0.3 + 0.2 * (double)(index % 3), 0.85, 0.3 + 0.2 * (double)(index / 3));
        stack.method_22907((Quaternionfc)class_7833.field_40714.rotation(1.5707964f));
        stack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(10.0f));
        stack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(10.0f));
        stack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(5.0f));
        stack.method_22905(0.375f, 0.375f, 0.375f);
        itemState.method_65604(stack, collector, light, class_4608.field_21444, 0);
        stack.method_22909();
    }

    private float calculateFlipProgress(float time) {
        if ((double)time <= 0.5) {
            return 1.0f - (float)Math.pow(1.0f - (time /= 0.5f), 4.0);
        }
        time -= 0.5f;
        return 1.0f - (time /= 0.5f) * time * time * time;
    }
}

