/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client.graphics;

import com.mrcrayfish.furniture.refurbished.computer.Display;
import com.mrcrayfish.furniture.refurbished.computer.app.Marketplace;
import com.mrcrayfish.furniture.refurbished.computer.client.DisplayableProgram;
import com.mrcrayfish.furniture.refurbished.computer.client.Icon;
import com.mrcrayfish.furniture.refurbished.computer.client.Scene;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerButton;
import com.mrcrayfish.furniture.refurbished.computer.client.widget.ComputerSelectionList;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.Optional;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4280;
import net.minecraft.class_5244;

public class MarketplaceGraphics
extends DisplayableProgram<Marketplace> {
    private static final class_2960 TEXTURE = Utils.resource("textures/gui/program/marketplace.png");
    private final Scene catalogueScene = new CatalogueScene(this);
    private final Scene shoppingCartScene = new ShoppingCartScene(this);
    private final Scene mailboxScene = new MailboxScene(this);

    public MarketplaceGraphics(Marketplace program) {
        super(program, 112, 54);
        this.setScene(new ComingSoon(this));
    }

    public static class CatalogueScene
    extends Scene {
        private final MarketplaceGraphics program;
        private final ComputerSelectionList<Item> itemList;

        private CatalogueScene(MarketplaceGraphics program) {
            this.program = program;
            this.itemList = this.addWidget(new ComputerSelectionList(program.getWidth() - 10, program.getHeight() - 26, 0, 100, 30));
            this.itemList.method_25396().add(new Item());
            this.itemList.method_25396().add(new Item());
            this.itemList.method_25396().add(new Item());
            this.itemList.method_25396().add(new Item());
            this.itemList.method_25396().add(new Item());
            this.itemList.method_25396().add(new Item());
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
            this.itemList.method_48229(contentStart + 5, contentTop + 21);
        }

        @Override
        public void render(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            graphics.method_25294(0, 0, this.program.getWidth(), 16, -10143432);
            graphics.method_25290(class_10799.field_56883, TEXTURE, 5, 2, 0.0f, 0.0f, 12, 12, 12, 12);
            graphics.method_25303(class_310.method_1551().field_1772, Integer.toString(this.getEmeraldCount()), 50, 5, -1);
        }

        private int getEmeraldCount() {
            return Optional.ofNullable(((Marketplace)this.program.getProgram()).getComputer().getMenu()).map(menu -> (int)menu.getProgramData()).orElse(0);
        }

        private static class Item
        extends class_4280.class_4281<Item> {
            private final ComputerButton buyButton = new ComputerButton(50, 16, (class_2561)class_2561.method_43470((String)"Buy"), btn -> System.out.println("Hello"));

            public class_2561 method_37006() {
                return class_5244.field_39003;
            }

            public void method_25343(class_332 graphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
                graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), -1);
                this.buyButton.method_48229(this.method_46426() + this.method_25368() - this.buyButton.method_25368(), this.method_46427());
                this.buyButton.method_25394(graphics, mouseX, mouseY, partialTick);
            }

            public boolean method_25402(class_11909 event, boolean doubleClick) {
                this.buyButton.method_25402(event, doubleClick);
                return true;
            }
        }
    }

    public static class ShoppingCartScene
    extends Scene {
        private ShoppingCartScene(MarketplaceGraphics program) {
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
        }

        @Override
        public void render(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        }
    }

    public static class MailboxScene
    extends Scene {
        private MailboxScene(MarketplaceGraphics program) {
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
        }

        @Override
        public void render(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        }
    }

    public static class ComingSoon
    extends Scene {
        private final MarketplaceGraphics program;

        public ComingSoon(MarketplaceGraphics program) {
            this.program = program;
        }

        @Override
        public void updateWidgets(int contentStart, int contentTop) {
        }

        @Override
        public void render(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            Icon icon = Display.get().getIcon(((Marketplace)this.program.getProgram()).getId());
            if (icon != null) {
                graphics.method_25290(class_10799.field_56883, icon.texture(), (this.program.getWidth() - 16) / 2, 10, (float)icon.u(), (float)icon.v(), 16, 16, 128, 128);
            }
            graphics.method_25300(class_310.method_1551().field_1772, "Coming Soon!", 56, 35, -1);
        }
    }
}

