/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.electricity;

import com.mrcrayfish.furniture.refurbished.core.ModItems;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSyncLink;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class LinkManager {
    public static final double MAX_LINK_LENGTH = 512.0;
    private final Map<UUID, class_2338> lastNodeMap = new HashMap<UUID, class_2338>();

    public static Optional<LinkManager> get(MinecraftServer server) {
        class_3218 level = server.method_3847(class_1937.field_25179);
        if (level != null) {
            return Optional.of(((Access)level).refurbishedFurniture$GetLinkManager());
        }
        return Optional.empty();
    }

    public void onNodeInteract(class_1937 level, class_1657 player, IElectricityNode node) {
        IElectricityNode n;
        IElectricityNode lastNode;
        if (!node.isNodeValid()) {
            return;
        }
        if (node.isNodeConnectionLimitReached()) {
            return;
        }
        if (this.startLinking(node.getNodePosition(), level, player)) {
            return;
        }
        class_2338 previousPos = this.lastNodeMap.get(player.method_5667());
        class_2586 class_25862 = level.method_8321(previousPos);
        IElectricityNode iElectricityNode = lastNode = class_25862 instanceof IElectricityNode ? (n = (IElectricityNode)class_25862) : null;
        if (lastNode != null && lastNode != node) {
            if (lastNode.isSourceNode() && node.isSourceNode()) {
                return;
            }
            int linkLength = (int)(lastNode.getNodePosition().method_46558().method_1022(node.getNodePosition().method_46558()) + 0.5);
            if ((double)linkLength <= 512.0) {
                this.lastNodeMap.remove(player.method_5667());
                lastNode.connectToNode(node);
                if (player.method_18276() && this.startLinking(node.getNodePosition(), level, player)) {
                    Network.getPlay().sendToPlayer(() -> (class_3222)player, (Object)new MessageSyncLink(node.getNodePosition()));
                    return;
                }
                level.method_45447(null, node.getNodePosition(), (class_3414)ModSounds.ITEM_WRENCH_CONNECTED_LINK.get(), class_3419.field_15245);
                Network.getPlay().sendToPlayer(() -> (class_3222)player, (Object)new MessageSyncLink(null));
            }
        }
    }

    private boolean startLinking(class_2338 pos, class_1937 level, class_1657 player) {
        if (!this.lastNodeMap.containsKey(player.method_5667())) {
            this.lastNodeMap.put(player.method_5667(), pos);
            level.method_45447(null, pos, (class_3414)ModSounds.ITEM_WRENCH_SELECTED_NODE.get(), class_3419.field_15245);
            Network.getPlay().sendToPlayer(() -> (class_3222)player, (Object)new MessageSyncLink(pos));
            return true;
        }
        return false;
    }

    public void onPlayerTick(class_1657 player) {
        UUID id = player.method_5667();
        if (this.lastNodeMap.containsKey(id) && !player.method_6047().method_31574((class_1792)ModItems.WRENCH.get())) {
            this.lastNodeMap.remove(id);
            Network.getPlay().sendToPlayer(() -> (class_3222)player, (Object)new MessageSyncLink(null));
        }
    }

    public void onPlayerLoggedOut(class_1657 player) {
        this.lastNodeMap.remove(player.method_5667());
    }

    public static interface Access {
        public LinkManager refurbishedFurniture$GetLinkManager();
    }
}

