/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.mail;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.blockentity.MailboxBlockEntity;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.mail.IMailbox;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.class_11560;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public final class Mailbox
implements IMailbox {
    public static final int MAX_NAME_LENGTH = 32;
    private static final Codec<Queue<class_1799>> ITEMSTACK_QUEUE_CODEC = class_1799.field_24671.listOf().flatXmap(list -> DataResult.success(new ArrayDeque(list)), queue -> DataResult.success(new ArrayList(queue)));
    public static final Codec<Mailbox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_25122.fieldOf("UUID").forGetter(Mailbox::id), (App)class_5321.method_39154((class_5321)class_7924.field_41223).fieldOf("Level").forGetter(Mailbox::levelKey), (App)class_2338.field_25064.fieldOf("BlockPosition").forGetter(Mailbox::pos), (App)ITEMSTACK_QUEUE_CODEC.fieldOf("Queue").forGetter(Mailbox::queue), (App)class_4844.field_25122.optionalFieldOf("Owner").forGetter(Mailbox::owner), (App)Codec.string((int)0, (int)32).optionalFieldOf("CustomName").orElse(Optional.of("Mailbox")).forGetter(Mailbox::customName)).apply((Applicative)instance, Mailbox::new));
    private final UUID id;
    private final class_5321<class_1937> levelKey;
    private final class_2338 pos;
    private final Queue<class_1799> queue;
    private Optional<UUID> owner;
    private Optional<String> customName;
    private DeliveryService service;
    private boolean removed;

    public Mailbox(UUID id, class_5321<class_1937> levelKey, class_2338 pos, Queue<class_1799> queue, Optional<UUID> owner, Optional<String> customName) {
        this.id = id;
        this.levelKey = levelKey;
        this.pos = pos;
        this.queue = queue;
        this.owner = owner;
        this.customName = customName;
    }

    public Mailbox(UUID id, class_5321<class_1937> levelKey, class_2338 pos) {
        this(id, levelKey, pos, new ArrayDeque<class_1799>(), Optional.empty(), Optional.empty());
    }

    public void setService(DeliveryService service) {
        if (this.service == null) {
            this.service = service;
        }
    }

    public boolean rename(String customName) {
        if (!customName.isBlank() && customName.length() <= 32) {
            this.customName = Optional.of(customName);
            this.service.method_80();
            return true;
        }
        return false;
    }

    public boolean hasOwner() {
        return this.owner.isPresent();
    }

    public void setOwner(UUID uuid) {
        this.owner = Optional.of(uuid);
        this.service.method_80();
    }

    public boolean removed() {
        return this.removed;
    }

    void tick(DeliveryService service) {
        if (this.removed) {
            return;
        }
        MinecraftServer server = service.getServer();
        class_3218 level = server.method_3847(this.levelKey);
        if (level == null || !level.method_8477(this.pos)) {
            return;
        }
        class_2586 class_25862 = level.method_8321(this.pos);
        if (class_25862 instanceof MailboxBlockEntity) {
            MailboxBlockEntity blockEntity = (MailboxBlockEntity)class_25862;
            if (blockEntity.getMailbox().stream().noneMatch(mailbox -> mailbox == this)) {
                service.removeMailbox(this);
                this.removed = true;
                return;
            }
            if (this.queue.isEmpty()) {
                return;
            }
            class_1799 stack = this.queue.peek();
            if (blockEntity.deliverItem(stack)) {
                this.queue.remove();
                service.method_80();
            }
        } else {
            service.removeMailbox(this);
            this.removed = true;
        }
    }

    void spawnQueueIntoLevel(DeliveryService service) {
        class_3218 level = service.getServer().method_3847(this.levelKey);
        if (level != null) {
            Queue<class_1799> queue = this.queue;
            while (!queue.isEmpty()) {
                class_1799 stack = queue.poll();
                class_1264.method_5449((class_1937)level, (double)this.pos.method_10263(), (double)this.pos.method_10264(), (double)this.pos.method_10260(), (class_1799)stack);
            }
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Mailbox mailbox = (Mailbox)obj;
        return this.id.equals(mailbox.id);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Optional<class_11560> getOwner() {
        UUID ownerId = this.owner.orElse(null);
        if (ownerId != null) {
            return this.service.getServer().method_73550().comp_4407().method_14512(ownerId);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getCustomName() {
        return this.customName;
    }

    public UUID id() {
        return this.id;
    }

    public class_5321<class_1937> levelKey() {
        return this.levelKey;
    }

    public class_2338 pos() {
        return this.pos;
    }

    public Optional<UUID> owner() {
        return this.owner;
    }

    public Optional<String> customName() {
        return this.customName;
    }

    public Queue<class_1799> queue() {
        return this.queue;
    }
}

